﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Likwidacja środka trwałego</title>
		<script runat="server">


		private void Dokument_OnLoad(Object sender, EventArgs args)
			{
        LT dokument     = (LT)DataContext1.Get(typeof(LT));
        SrodekTrwalyBaseHistoria hist = dokument.PozycjaLT.SrodekTrwaly[dokument.DataOperacji];

		ReportHeader1.Title = HttpUtility.HtmlEncode(string.Format(ReportHeader1.Title,
			hist.WybierzNazwe ( "Likwidacja środka trwałego" , "Likwidacja wartości niematerialnej/prawnej" , "Likwidacja wyposażenia" ),
			dokument.Numer, dokument.Data, dokument.DataOperacji, dokument.Tytul));
        
        DataLabelNrInw.EditValue = hist.Srodek.NumerInwentarzowy;
        DataLabelNazwa.EditValue = hist.Srodek.Nazwa;
        DataLabelOpis.EditValue = hist.Srodek.Opis;          
        DataLabelKST.EditValue = hist.KRST;
        DataLabelNrFabryczny.EditValue = hist.Srodek.NumerFabryczny;
          
        DataLabelAmortyzacjaBilansowa.EditValue = hist.Bilansowa;
        DataLabelAmortyzacjaPodatkowa.EditValue = hist.Podatkowa;
        DataLabelWartoscBilansowa.EditValue = dokument.PozycjaLT.WartoscBilansowa;
        DataLabelWartoscPodatkowa.EditValue = dokument.PozycjaLT.WartoscPodatkowa;
        DataLabelAmortyzacjaLTBilansowa.EditValue = -dokument.PozycjaAmortyzacji.WartoscBilansowa;
        DataLabelAmortyzacjaLTPodatkowa.EditValue = -dokument.PozycjaAmortyzacji.WartoscPodatkowa;
        DataLabelWartośćNieumorzonaBilansowa.EditValue = dokument.PozycjaLT.WartoscBilansowa+dokument.PozycjaAmortyzacji.WartoscBilansowa;
        DataLabelWartoscNieumorzonaPodatkowa.EditValue = dokument.PozycjaLT.WartoscPodatkowa+dokument.PozycjaAmortyzacji.WartoscPodatkowa;                              
          
        DataLabelMiejsceUzytk.EditValue = hist.MiejsceUzytkowania;
        DataLabelCentrumKosztow.EditValue = hist.CentrumKosztow;

        DataLabelDokumentPozyskania.EditValue = hist.Srodek.ZbycieNrDokumentu;
        DataLabelDataPozyskania.EditValue = hist.Srodek.ZbycieData;
        PodmiotEwidencja ewid = hist.Srodek.ZbycieDokument as PodmiotEwidencja;
        if (ewid != null)
            DataLabelPodmiot.EditValue = string.Format("{0} ({1}) - {2}", ewid.DaneKontrahenta.Nazwa, ewid.DaneKontrahenta.NIP, ewid.DaneKontrahenta.Adres);
        DataLabelOdpowiedzialny.EditValue = hist.Odpowiedzialny!=null ? hist.Odpowiedzialny.ToString() : hist.Nazwisko;                            
      }
		</script>
	</HEAD>


	<body>
		<form id="Dokument" method="post" runat="server">
			<P>
				<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"
					OnContextLoad="Dokument_OnLoad"></ea:DataContext><BR>
				<cc1:ReportHeader id="ReportHeader1" runat="server" title="{0} {1} | Data: {2}, Data operacji: {3} | Tytuł: {4}"></cc1:ReportHeader><BR>
			</P>
			<TABLE id="Table1" cellSpacing="0" cellPadding="1" width="100%" border="1">
				<COLGROUP width="20%">
				</COLGROUP>
				<COLGROUP width="30%">
				</COLGROUP>
				<COLGROUP width="20%">
				</COLGROUP>
				<COLGROUP width="30%">
				</COLGROUP>
				<TR>
					<TD><FONT face="Tahoma" size="2">Nr inwentarzowy:</FONT></TD>
					<TD>
						<ea:DataLabel id="DataLabelNrInw" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
					<TD><FONT face="Tahoma" size="2">Nazwa:</FONT></TD>
					<TD>
						<ea:DataLabel id="DataLabelNazwa" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
				</TR>
				<TR>
					<TD><FONT face="Tahoma" size="2">KŚT:</FONT></TD>
					<TD>
						<ea:DataLabel id="DataLabelKST" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
					<TD><FONT face="Tahoma" size="2">Nr fabryczny:</FONT></TD>
					<TD>
						<ea:DataLabel id="DataLabelNrFabryczny" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                        &nbsp;</TD>
				</TR>
				<TR>
					<TD><FONT face="Tahoma" size="2">Opis:</FONT></TD>
					<TD colSpan="3">
						<ea:DataLabel id="DataLabelOpis" EncodeHTML="true" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                        &nbsp;</TD>
				</TR>
			</TABLE>
			<P>
				<TABLE id="Table2" cellSpacing="0" cellPadding="1" width="100%" border="1">
					<COLGROUP width="20%">
					</COLGROUP>
					<COLGROUP width="30%">
					</COLGROUP>
					<COLGROUP width="20%">
					</COLGROUP>
					<COLGROUP width="30%">
					</COLGROUP>
					<TR>
						<TD style="HEIGHT: 36px; width: 23%;"><FONT face="Tahoma" size="2">Amortyzacja bilansowa:</FONT></TD>
						<TD style="HEIGHT: 36px; width: 20%;" align="right">
							<ea:DataLabel id="DataLabelAmortyzacjaBilansowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
						<TD style="HEIGHT: 36px; width: 23%;"><FONT face="Tahoma" size="2">Amortyzacja podatkowa:</FONT></TD>
						<TD style="HEIGHT: 36px; width: 20%;" align="right">
							<ea:DataLabel id="DataLabelAmortyzacjaPodatkowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
					</TR>
					<TR>
						<TD style="width: 23%; height: 36px;"><FONT face="Tahoma" size="2">Wartość bilansowa:</FONT></TD>
						<TD style="width: 20%; height: 36px;" align="right">
							<ea:DataLabel id="DataLabelWartoscBilansowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
						<TD style="width: 23%; height: 36px;"><FONT face="Tahoma" size="2">Wartość podatkowa:</FONT></TD>
						<TD style="width: 20%; height: 36px;" align="right">
							<ea:DataLabel id="DataLabelWartoscPodatkowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel></TD>
					</TR>
                    <tr>
                        <td style="width: 23%; height: 36px">
                            <span style="font-size: 10pt; font-family: Tahoma">Dotychczasowe umorzenie bilansowe:</span></td>
                        <td style="width: 20%; height: 36px" align="right"><ea:DataLabel id="DataLabelAmortyzacjaLTBilansowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega">
                        </ea:DataLabel>
                        </td>
                        <td style="width: 23%; height: 36px">
                            <span style="font-size: 10pt; font-family: Tahoma">Dotychczasowe umorzenie podatkowe:</span></td>
                        <td style="width: 20%; height: 36px" align="right"><ea:DataLabel id="DataLabelAmortyzacjaLTPodatkowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega">
                        </ea:DataLabel>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 23%; height: 36px;">
                            <span style="font-size: 10pt; font-family: Tahoma">Wartość nieumorzona bilansowa:</span></td>
                        <td style="width: 20%; height: 36px;" align="right"><ea:DataLabel id="DataLabelWartośćNieumorzonaBilansowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega">
                        </ea:DataLabel>
                        </td>
                        <td style="width: 23%; height: 36px;">
                            <span style="font-size: 10pt; font-family: Tahoma">Wartość nieumorzona podatkowa:</span></td>
                        <td style="width: 20%; height: 36px;" align="right"><ea:DataLabel id="DataLabelWartoscNieumorzonaPodatkowa" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega">
                        </ea:DataLabel>
                        </td>
                    </tr>
				</TABLE>
			</P>
			<P>
				<TABLE id="Table3" cellSpacing="0" cellPadding="1" width="100%" border="1">
					<COLGROUP width="20%">
					</COLGROUP>
					<COLGROUP width="30%">
					</COLGROUP>
					<COLGROUP width="20%">
					</COLGROUP>
					<COLGROUP width="30%">
					</COLGROUP>
					<TR>
						<TD><FONT face="Tahoma" size="2">Miejsce użytkowania:</FONT></TD>
						<TD style="width: 30%">
							<ea:DataLabel id="DataLabelMiejsceUzytk" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
						<TD><FONT face="Tahoma" size="2">Centrum kosztów:</FONT></TD>
						<TD>
							<ea:DataLabel id="DataLabelCentrumKosztow" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
					</TR>
					<TR>
						<TD><FONT face="Tahoma" size="2">Dokument zbycia:</FONT></TD>
						<TD style="width: 30%">
							<ea:DataLabel id="DataLabelDokumentPozyskania" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
						<TD><FONT face="Tahoma" size="2">Data zbycia:</FONT></TD>
						<TD>
							<ea:DataLabel id="DataLabelDataPozyskania" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
					</TR>
					<TR>
						<TD style="height: 23px">
                            <span style="font-size: 10pt; font-family: Tahoma">Podmiot dok. zbycia:</span></TD>
						<TD colSpan="3" style="height: 23px">
							<ea:DataLabel id="DataLabelPodmiot" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
					</TR>
					<TR>
						<TD><FONT face="Tahoma" size="2">Odpowiedzialny:</FONT></TD>
						<TD colSpan="3">
							<ea:DataLabel id="DataLabelOdpowiedzialny" runat="server" ContextTypeName="Soneta.SrodkiTrwale.LT,Soneta.Ksiega"></ea:DataLabel>
                            &nbsp;</TD>
					</TR>
				</TABLE>
			</P>
			<P>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle Caption="Uwagi/Orzeczenie komisji likwidacyjnej" Width="100"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Podpisy komisji likwidacyjnej" Width="75"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Podpis osoby odpowiedzialnej za środek trwały"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter>&nbsp;</P>
		</form>
	</body>
</HTML>

